import { NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { globalSettings } from '@/lib/db/schema'

export async function GET() {
    try {
        const settings = await db.query.globalSettings.findFirst()

        if (!settings) {
            return NextResponse.json({ error: 'Settings not found' }, { status: 500 })
        }

        const bankDetails = {
            EUR: {
                beneficiary: settings.eurBeneficiary || '',
                iban: settings.eurIban || '',
                bic: settings.eurBic || '',
                bankName: settings.eurBankName || '',
                bankAddress: settings.eurBankAddress || ''
            },
            USD: {
                beneficiary: settings.usdBeneficiary || '',
                accountNumber: settings.usdAccountNumber || '',
                routingNumber: settings.usdRoutingNumber || '',
                bic: settings.usdBic || '',
                accountType: settings.usdAccountType || '',
                bankName: settings.usdBankName || '',
                bankAddress: settings.usdBankAddress || ''
            }
        }

        return NextResponse.json(bankDetails)
    } catch (error) {
        console.error('Error fetching bank details:', error)
        return NextResponse.json({ error: 'Failed to fetch bank details' }, { status: 500 })
    }
}
