import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'
import { authenticateRequest } from '@/lib/auth-middleware'

export async function GET(request: NextRequest) {
    try {
        const authResult = await authenticateRequest(request)
        if (!authResult.success) {
            return NextResponse.json({ error: authResult.error }, { status: 401 })
        }

        const [user] = await db
            .select({ balance: users.balance })
            .from(users)
            .where(eq(users.id, authResult.userId))

        if (!user) {
            return NextResponse.json({ error: 'User not found' }, { status: 404 })
        }

        return NextResponse.json({
            balance: parseFloat(user.balance) || 0
        })

    } catch (error) {
        console.error('Balance fetch error:', error)
        return NextResponse.json({ error: 'Erreur serveur' }, { status: 500 })
    }
}
