import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { campaigns, users } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'

import { auth } from '@/auth'

export async function GET(request: NextRequest) {
  try {
    const session = await auth()
    if (!session || session.user.role !== 'creator') {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })
    }

    // Get all active campaigns
    const activeCampaigns = await db
      .select({
        id: campaigns.id,
        title: campaigns.title,
        description: campaigns.description,
        budget: campaigns.budget,
        pricePerView: campaigns.pricePerView,
        status: campaigns.status,
        coverImage: campaigns.coverImage,
        icon: campaigns.icon,
        startDate: campaigns.startDate,
        endDate: campaigns.endDate,
        studioId: campaigns.studioId,
        studioName: users.name,
        studioCompany: users.company,
      })
      .from(campaigns)
      .leftJoin(users, eq(campaigns.studioId, users.id))
      .where(eq(campaigns.status, 'active'))

    return NextResponse.json({ campaigns: activeCampaigns })
  } catch (error) {
    console.error('Get campaigns error:', error)
    return NextResponse.json(
      { error: 'Erreur lors de la récupération des campagnes' },
      { status: 500 }
    )
  }
}
