import { NextRequest, NextResponse } from 'next/server'
import { db } from '@/lib/db'
import { submissions, campaigns } from '@/lib/db/schema'
import { eq } from 'drizzle-orm'
import { auth } from '@/auth'

export async function GET(request: NextRequest) {
  try {
    const session = await auth()
    if (!session || !session.user || !session.user.id) {
      return NextResponse.json({ error: 'Non autorisé' }, { status: 401 })
    }

    const userId = session.user.id

    // Get all submissions for this creator
    const userSubmissions = await db
      .select({
        id: submissions.id,
        videoUrl: submissions.videoUrl,
        platform: submissions.platform,
        status: submissions.status,
        viewsCount: submissions.viewsCount,
        revenue: submissions.revenue,
        submittedAt: submissions.submittedAt,
        reviewedAt: submissions.reviewedAt,
        campaignId: campaigns.id,
        campaignTitle: campaigns.title,
      })
      .from(submissions)
      .leftJoin(campaigns, eq(submissions.campaignId, campaigns.id))
      .where(eq(submissions.creatorId, userId))

    return NextResponse.json({ submissions: userSubmissions })
  } catch (error) {
    console.error('Get submissions error:', error)
    return NextResponse.json(
      { error: 'Erreur lors de la récupération des soumissions' },
      { status: 500 }
    )
  }
}
