import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { db } from '@/lib/db'
import { users } from '@/lib/db/schema'
import { eq, and } from 'drizzle-orm'
import { getTranslations } from 'next-intl/server'

export async function GET(request: NextRequest) {
  const t = await getTranslations('Api.Errors')

  try {
    const session = await auth()
    if (!session || session.user.role !== 'admin') {
      return NextResponse.json({ error: t('unauthorized') }, { status: 401 })
    }

    const requests = await db.query.users.findMany({
      where: and(
        eq(users.role, 'studio'),
        eq(users.isApproved, 0)
      ),
      orderBy: (users, { desc }) => [desc(users.createdAt)]
    })

    return NextResponse.json({ requests })
  } catch (error) {
    console.error('Error fetching requests:', error)
    return NextResponse.json({ error: t('server_error') }, { status: 500 })
  }
}
