import { NextRequest, NextResponse } from 'next/server'
import { auth } from '@/auth'
import { writeFile } from 'fs/promises'
import { join } from 'path'
import { mkdir } from 'fs/promises'

export async function POST(req: NextRequest) {
    const session = await auth()
    if (!session) {
        return new NextResponse('Unauthorized', { status: 401 })
    }

    try {
        const formData = await req.formData()
        const file = formData.get('file') as File

        if (!file) {
            return new NextResponse('No file uploaded', { status: 400 })
        }

        const bytes = await file.arrayBuffer()
        const buffer = Buffer.from(bytes)

        // Create uploads directory if it doesn't exist
        const uploadDir = join(process.cwd(), 'public', 'uploads', 'proofs')
        await mkdir(uploadDir, { recursive: true })

        // Generate unique filename
        const filename = `${Date.now()}-${Math.random().toString(36).substring(7)}-${file.name.replace(/[^a-zA-Z0-9.]/g, '')}`
        const filepath = join(uploadDir, filename)

        await writeFile(filepath, buffer)

        const url = `/uploads/proofs/${filename}`

        return NextResponse.json({ url })
    } catch (error) {
        console.error('Error uploading proof:', error)
        return new NextResponse('Internal Server Error', { status: 500 })
    }
}
