import type { NextAuthConfig } from "next-auth"

export const authConfig = {
    pages: {
        signIn: "/auth",
    },
    cookies: {
        sessionToken: {
            name: `next-auth.session-token`,
            options: {
                httpOnly: true,
                sameSite: 'lax',
                path: '/',
                secure: true,
                domain: '.swiplay.com',
            },
        },
    },
    callbacks: {
        authorized({ auth, request: { nextUrl } }) {
            const isLoggedIn = !!auth?.user
            const pathname = nextUrl.pathname

            // Check if the path starts with a locale (e.g., /fr/creator or /en/creator)
            // or if it's a direct access (e.g., /creator) which middleware will redirect
            const pathWithoutLocale = pathname.replace(/^\/(en|fr)/, '')

            const isOnDashboard = (pathWithoutLocale.startsWith("/creator") && !pathWithoutLocale.startsWith("/creator/onboarding")) ||
                pathWithoutLocale.startsWith("/studio") ||
                pathWithoutLocale.startsWith("/ops")

            if (isOnDashboard) {
                if (isLoggedIn) return true
                return false // Redirect unauthenticated users to login page
            } else if (isLoggedIn) {
                // Redirect logged-in users to their respective dashboard if they visit login/register
                // This logic can be refined later
                return true
            }
            return true
        },
        jwt({ token, user }) {
            if (user) {
                token.role = user.role
                token.id = user.id
                token.onboardingComplete = user.onboardingComplete
            }
            return token
        },
        session({ session, token }) {
            if (token && session.user) {
                session.user.role = token.role as string
                session.user.id = token.id as string
                session.user.onboardingComplete = token.onboardingComplete as number
            }
            return session
        },
    },
    providers: [], // Add providers with an empty array for now
} satisfies NextAuthConfig
