import { ReactNode } from 'react'

interface AdminHeaderProps {
    title: string
    description?: string
    actions?: ReactNode
}

export function AdminHeader({ title, description, actions }: AdminHeaderProps) {
    return (
        <div className="flex flex-col sm:flex-row sm:items-center justify-between gap-4 mb-8">
            <div>
                <h1 className="text-3xl font-bold tracking-tight">{title}</h1>
                {description && <p className="text-gray-400 mt-1">{description}</p>}
            </div>
            {actions && <div className="flex items-center gap-3">{actions}</div>}
        </div>
    )
}
