'use client'

import { Search } from 'lucide-react'
import { useRouter, useSearchParams, usePathname } from 'next/navigation'
import { useTransition, useEffect, useState } from 'react'
import { Input } from '@/components/ui/input'

export function AdminSearch({ placeholder = 'Rechercher...' }: { placeholder?: string }) {
    const router = useRouter()
    const pathname = usePathname()
    const searchParams = useSearchParams()
    const [isPending, startTransition] = useTransition()
    const [value, setValue] = useState(searchParams.get('query') || '')

    // Simple debounce logic inside component if hook doesn't exist
    useEffect(() => {
        const timer = setTimeout(() => {
            const params = new URLSearchParams(searchParams)
            if (value) {
                params.set('query', value)
            } else {
                params.delete('query')
            }
            params.set('page', '1') // Reset to page 1 on search

            startTransition(() => {
                router.replace(`${pathname}?${params.toString()}`)
            })
        }, 500)

        return () => clearTimeout(timer)
    }, [value, pathname, router, searchParams])

    return (
        <div className="relative w-full max-w-sm">
            <Search className="absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-400" />
            <Input
                value={value}
                onChange={(e) => setValue(e.target.value)}
                placeholder={placeholder}
                className="pl-9 bg-white/[0.03] border-white/10 focus:bg-white/[0.05]"
            />
            {isPending && (
                <div className="absolute right-3 top-1/2 -translate-y-1/2">
                    <div className="w-4 h-4 border-2 border-purple-500 border-t-transparent rounded-full animate-spin" />
                </div>
            )}
        </div>
    )
}
