'use client'

import { useState } from 'react'
import { Button } from '@/components/ui/button'
import { CheckCircle, Loader2 } from 'lucide-react'
import { toast } from 'sonner'
import { useRouter } from 'next/navigation'

interface ApproveCreatorButtonProps {
    creatorId: string
    isApproved: boolean
}

export function ApproveCreatorButton({ creatorId, isApproved }: ApproveCreatorButtonProps) {
    const [loading, setLoading] = useState(false)
    const router = useRouter()

    if (isApproved) return null

    const handleApprove = async (e: React.MouseEvent) => {
        e.preventDefault()
        e.stopPropagation()
        setLoading(true)
        try {
            const res = await fetch(`/api/ops/creators/${creatorId}/approve`, {
                method: 'POST'
            })

            if (!res.ok) throw new Error('Erreur lors de l\'approbation')

            toast.success('Créateur approuvé avec succès')
            router.refresh()
        } catch (error) {
            console.error(error)
            toast.error('Impossible d\'approuver le créateur')
        } finally {
            setLoading(false)
        }
    }

    return (
        <Button
            onClick={handleApprove}
            disabled={loading}
            className="bg-green-600 hover:bg-green-700 text-white gap-2"
        >
            {loading ? <Loader2 className="w-4 h-4 animate-spin" /> : <CheckCircle className="w-4 h-4" />}
            Approuver le compte
        </Button>
    )
}
