'use client'

import Link from 'next/link'
import { usePathname } from 'next/navigation'
import { Shield, Users, Building2, Settings, LayoutDashboard, LogOut, FileText, Wallet } from 'lucide-react'
import { cn } from '@/lib/utils'
import { signOut } from 'next-auth/react'

const navigation = [
    { name: 'Vue d\'ensemble', href: '/ops', icon: LayoutDashboard },
    { name: 'Créateurs', href: '/ops/creators', icon: Users },
    { name: 'Studios', href: '/ops/studios', icon: Building2 },
    { name: 'Facturation', href: '/ops/billing', icon: FileText },
    { name: 'Factures Studios', href: '/ops/payouts', icon: FileText },
    { name: 'Retraits Créateurs', href: '/ops/withdrawals', icon: Wallet },
    { name: 'Paramètres', href: '/ops/settings', icon: Settings },
]

export function Sidebar() {
    const pathname = usePathname()

    return (
        <div className="flex w-64 flex-col bg-zinc-900 border-r border-white/10">
            <div className="flex h-16 items-center px-6 border-b border-white/10">
                <Shield className="h-8 w-8 text-purple-500 mr-2" />
                <span className="text-lg font-bold">Swiplay Ops</span>
            </div>
            <nav className="flex-1 space-y-1 px-2 py-4">
                {navigation.map((item) => {
                    const isActive = pathname === item.href
                    return (
                        <Link
                            key={item.name}
                            href={item.href}
                            className={cn(
                                isActive
                                    ? 'bg-purple-500/10 text-purple-400'
                                    : 'text-gray-400 hover:bg-white/5 hover:text-white',
                                'group flex items-center px-4 py-3 text-sm font-medium rounded-lg transition-colors'
                            )}
                        >
                            <item.icon
                                className={cn(
                                    isActive ? 'text-purple-400' : 'text-gray-400 group-hover:text-white',
                                    'mr-3 h-5 w-5 flex-shrink-0'
                                )}
                            />
                            {item.name}
                        </Link>
                    )
                })}
            </nav>
            <div className="p-4 border-t border-white/10">
                <button
                    onClick={() => signOut({ callbackUrl: 'https://swiplay.com' })}
                    className="flex w-full items-center px-4 py-3 text-sm font-medium text-gray-400 hover:bg-red-500/10 hover:text-red-400 rounded-lg transition-colors"
                >
                    <LogOut className="mr-3 h-5 w-5" />
                    Déconnexion
                </button>
            </div>
        </div>
    )
}
