'use client'

import { useEffect } from 'react'
import { useRouter, usePathname } from 'next/navigation'
import { useAuth } from '@/lib/auth-store'

export function OnboardingGuard({ children }: { children: React.ReactNode }) {
    const router = useRouter()
    const pathname = usePathname()
    const user = useAuth((state) => state.user)
    const isLoading = useAuth((state) => state.isLoading)

    useEffect(() => {
        if (isLoading) return

        if (user && !user.onboardingComplete && !pathname.includes('/creator/onboarding')) {
            router.push('/creator/onboarding')
        }
    }, [user, isLoading, pathname, router])

    return <>{children}</>
}
