'use client'

import { useEffect } from 'react'
import { useAuth } from '@/lib/auth-store'
import { Session } from 'next-auth'

export function SessionSync({ session }: { session: Session | null }) {
    const setAuth = useAuth((state) => state.setAuth)
    const logout = useAuth((state) => state.logout)

    useEffect(() => {
        if (session?.user) {
            setAuth(session.user, session.accessToken || '', session.refreshToken || '')
        } else {
            // If no session, ensure store is cleared
            // But be careful not to clear if we are just navigating and session is loading
            // For now, we trust that if session is null here, user is logged out
            // logout() 
        }
    }, [session, setAuth, logout])

    return null
}
