'use client'

import { useState } from 'react'
import { Play, Image as ImageIcon } from 'lucide-react'
import { cn } from '@/lib/utils'

interface CampaignGalleryProps {
    coverImage: string | null
    images: string[] | null
    videos: string[] | null
}

export function CampaignGallery({ coverImage, images = [], videos = [] }: CampaignGalleryProps) {
    const allMedia = [
        ...(videos || []).map(url => ({ type: 'video' as const, url })),
        ...(coverImage ? [{ type: 'image' as const, url: coverImage }] : []),
        ...(images || []).map(url => ({ type: 'image' as const, url }))
    ]

    const [selectedIndex, setSelectedIndex] = useState(0)
    const currentMedia = allMedia[selectedIndex]

    if (allMedia.length === 0) {
        return (
            <div className="w-full aspect-video bg-zinc-900 rounded-xl flex items-center justify-center border border-white/10">
                <ImageIcon className="w-12 h-12 text-zinc-700" />
            </div>
        )
    }

    return (
        <div className="space-y-4">
            {/* Main Viewer */}
            <div className="w-full aspect-video bg-black rounded-xl overflow-hidden border border-white/10 relative shadow-2xl">
                {currentMedia.type === 'video' ? (
                    <div className="w-full h-full flex items-center justify-center bg-black">
                        {/* Simple iframe for YouTube/Embeds or video tag for direct links */}
                        {currentMedia.url.includes('youtube') || currentMedia.url.includes('youtu.be') ? (
                            <iframe
                                src={currentMedia.url.replace('watch?v=', 'embed/')}
                                className="w-full h-full"
                                allowFullScreen
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                            />
                        ) : (
                            <video src={currentMedia.url} controls className="w-full h-full" />
                        )}
                    </div>
                ) : (
                    <img
                        src={currentMedia.url}
                        alt="Campaign Media"
                        className="w-full h-full object-contain bg-black/50 backdrop-blur-sm"
                    />
                )}
            </div>

            {/* Thumbnails */}
            <div className="flex gap-2 overflow-x-auto pb-2 scrollbar-thin scrollbar-thumb-white/10 scrollbar-track-transparent">
                {allMedia.map((media, idx) => (
                    <button
                        key={idx}
                        onClick={() => setSelectedIndex(idx)}
                        className={cn(
                            "relative flex-shrink-0 w-24 h-16 rounded-lg overflow-hidden border-2 transition-all",
                            selectedIndex === idx ? "border-purple-500 ring-2 ring-purple-500/20" : "border-transparent opacity-60 hover:opacity-100"
                        )}
                    >
                        {media.type === 'video' ? (
                            <div className="w-full h-full bg-zinc-900 flex items-center justify-center">
                                <Play className="w-6 h-6 text-white/80" />
                            </div>
                        ) : (
                            <img src={media.url} className="w-full h-full object-cover" />
                        )}
                    </button>
                ))}
            </div>
        </div>
    )
}
