'use client'

import { Button } from '@/components/ui/button'
import { Clock, LogOut } from 'lucide-react'
import { signOut } from 'next-auth/react'
import Link from 'next/link'

export function VerificationPending() {
    const handleLogout = async () => {
        await signOut({ callbackUrl: '/auth' })
    }

    return (
        <div className="min-h-screen bg-black text-white flex flex-col items-center justify-center p-6 relative overflow-hidden">
            {/* Background Elements */}
            <div className="fixed inset-0 -z-10 pointer-events-none">
                <div className="absolute top-0 left-1/4 w-96 h-96 bg-purple-600/10 rounded-full blur-[100px]" />
                <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-blue-600/10 rounded-full blur-[100px]" />
                <div className="absolute inset-0 bg-[url('/noise.png')] opacity-[0.02] mix-blend-overlay" />
            </div>

            <div className="w-full max-w-md text-center space-y-8 relative z-10">
                <div className="flex justify-center">
                    <div className="w-24 h-24 rounded-full bg-yellow-500/10 border border-yellow-500/20 flex items-center justify-center animate-pulse">
                        <Clock className="w-12 h-12 text-yellow-500" />
                    </div>
                </div>

                <div className="space-y-4">
                    <h1 className="text-3xl font-bold bg-clip-text text-transparent bg-gradient-to-r from-white to-gray-400">
                        Vérification en cours
                    </h1>
                    <p className="text-gray-400 mb-8 max-w-md mx-auto">
                        Votre profil est en cours de vérification par notre équipe. Cela prend généralement moins de 24 heures. Vous recevrez un email dès que votre compte sera validé.
                    </p>
                </div>

                <div className="pt-8">
                    <Button
                        variant="ghost"
                        onClick={handleLogout}
                        className="text-gray-500 hover:text-white hover:bg-white/5 gap-2"
                    >
                        <LogOut className="w-4 h-4" />
                        Se déconnecter
                    </Button>
                </div>
            </div>
        </div>
    )
}
