'use client'

import { useTranslations } from 'next-intl'
import { Search, Menu } from 'lucide-react'
import { Button } from '@/components/ui/button'
import { Notifications } from '@/components/dashboard/Notifications'
import { toast } from 'sonner'

interface DashboardHeaderProps {
    title: string
    description?: string
}

export function DashboardHeader({ title, description }: DashboardHeaderProps) {
    const t = useTranslations('Dashboard.Header')

    return (
        <header className="h-20 border-b border-white/5 bg-black/20 backdrop-blur-sm flex items-center justify-between px-8 sticky top-0 z-30">
            <div>
                <h1 className="text-xl font-bold text-white">{title}</h1>
                {description && <p className="text-sm text-gray-400">{description}</p>}
            </div>

            <div className="flex items-center gap-4">
                <div className="relative hidden md:block">
                    <Search className="absolute left-3 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-500" />
                    <input
                        type="text"
                        placeholder={t('search')}
                        className="h-10 pl-10 pr-4 bg-white/5 border border-white/10 rounded-full text-sm text-white placeholder:text-gray-600 focus:outline-none focus:border-white/20 w-64 transition-all focus:w-80"
                        onKeyDown={(e) => {
                            if (e.key === 'Enter') {
                                toast.info("La recherche sera bientôt disponible")
                            }
                        }}
                    />
                </div>

                <Notifications />

                <Button variant="ghost" size="icon" className="md:hidden rounded-full text-gray-400 hover:text-white hover:bg-white/10">
                    <Menu className="w-5 h-5" />
                </Button>
            </div>
        </header>
    )
}
