'use client'

import { useAuth } from '@/lib/auth-store'
import { formatCurrency } from '@/lib/utils'
import { Wallet, TrendingUp, ArrowRight } from 'lucide-react'
import Link from 'next/link'
import { Button } from '@/components/ui/button'

interface DashboardHeroProps {
    userName: string
    userImage: string | null
    balance: string
}

export function DashboardHero({ userName, userImage, balance }: DashboardHeroProps) {
    const firstName = userName.split(' ')[0]

    return (
        <div className="relative overflow-hidden rounded-3xl bg-gradient-to-br from-purple-900/50 via-black to-black border border-white/10 p-8 md:p-12">
            {/* Background Effects */}
            <div className="absolute top-0 right-0 w-96 h-96 bg-purple-500/20 blur-[100px] rounded-full -mr-20 -mt-20 pointer-events-none" />
            <div className="absolute bottom-0 left-0 w-64 h-64 bg-blue-500/10 blur-[80px] rounded-full -ml-10 -mb-10 pointer-events-none" />

            <div className="relative z-10 flex flex-col md:flex-row items-center md:items-start gap-8 md:gap-12">
                {/* Avatar */}
                <div className="relative group">
                    <div className="w-32 h-32 md:w-40 md:h-40 rounded-full border-4 border-white/10 shadow-2xl overflow-hidden bg-zinc-900">
                        {userImage ? (
                            <img src={userImage} alt={userName} className="w-full h-full object-cover" />
                        ) : (
                            <div className="w-full h-full flex items-center justify-center bg-purple-500/20 text-purple-400 text-4xl font-bold">
                                {firstName[0]}
                            </div>
                        )}
                    </div>
                    <div className="absolute -bottom-2 -right-2 bg-green-500 text-black text-xs font-bold px-3 py-1 rounded-full border-4 border-black">
                        VERIFIED
                    </div>
                </div>

                {/* Content */}
                <div className="flex-1 text-center md:text-left space-y-6">
                    <div>
                        <h1 className="text-4xl md:text-5xl font-black text-white mb-2 tracking-tight">
                            Hello, <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-blue-400">{firstName}</span> !
                        </h1>
                        <p className="text-gray-400 text-lg">Prêt à exploser les compteurs aujourd'hui ?</p>
                    </div>

                    <div className="flex flex-col md:flex-row items-center gap-6">
                        {/* Balance Card */}
                        <div className="bg-white/5 backdrop-blur-md border border-white/10 rounded-2xl p-6 min-w-[280px] hover:bg-white/10 transition-colors group cursor-default">
                            <div className="flex items-center gap-3 mb-2 text-gray-400 group-hover:text-white transition-colors">
                                <Wallet className="w-5 h-5" />
                                <span className="font-medium">Solde Disponible</span>
                            </div>
                            <div className="flex items-baseline gap-2">
                                <span className="text-4xl font-bold text-white tracking-tight">{formatCurrency(parseFloat(balance))}</span>
                                <span className="text-sm text-green-400 font-medium flex items-center bg-green-500/10 px-2 py-0.5 rounded-full">
                                    <TrendingUp className="w-3 h-3 mr-1" />
                                    Live
                                </span>
                            </div>
                        </div>

                        {/* Actions */}
                        <div className="flex gap-3">
                            <Link href="/creator/campaigns">
                                <Button className="h-14 px-8 bg-white text-black hover:bg-gray-200 rounded-xl font-bold text-lg shadow-lg shadow-white/5">
                                    Trouver une campagne <ArrowRight className="ml-2 w-5 h-5" />
                                </Button>
                            </Link>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}
