'use client'

import { useState } from 'react'
import { DashboardSidebar } from '@/components/dashboard/DashboardSidebar'
import { MobileTopBar } from '@/components/dashboard/MobileTopBar'

interface DashboardLayoutWrapperProps {
    children: React.ReactNode
    navItems: any[]
    role: 'creator' | 'studio' | 'admin'
    user: any
}

export function DashboardLayoutWrapper({ children, navItems, role, user }: DashboardLayoutWrapperProps) {
    const [sidebarOpen, setSidebarOpen] = useState(false)

    return (
        <div className="min-h-screen bg-background text-foreground flex">
            <MobileTopBar onMenuClick={() => setSidebarOpen(true)} />

            <DashboardSidebar
                items={navItems}
                role={role}
                user={user}
                isOpen={sidebarOpen}
                onClose={() => setSidebarOpen(false)}
            />

            <main className="flex-1 md:ml-64 min-h-screen relative pt-16 md:pt-0">
                {children}
            </main>
        </div>
    )
}
