'use client'

import { Menu } from 'lucide-react'
import Image from 'next/image'
import Link from 'next/link'

interface MobileTopBarProps {
    onMenuClick: () => void
}

export function MobileTopBar({ onMenuClick }: MobileTopBarProps) {
    return (
        <div className="md:hidden fixed top-0 left-0 right-0 h-16 bg-black/40 backdrop-blur-xl border-b border-white/10 z-40 flex items-center justify-between px-4">
            <div className="flex items-center gap-3">
                <button
                    onClick={onMenuClick}
                    className="p-2 -ml-2 text-gray-400 hover:text-white transition-colors"
                >
                    <Menu className="w-6 h-6" />
                </button>

                <Link href="/" className="flex items-center gap-2">
                    <div className="w-8 h-8 relative flex items-center justify-center">
                        <Image
                            src="/swiplay-logo.png"
                            alt="Swiplay Logo"
                            width={32}
                            height={32}
                            className="object-contain"
                        />
                    </div>
                    <span className="text-lg font-bold bg-clip-text text-transparent bg-gradient-to-r from-white to-gray-400">
                        Swiplay
                    </span>
                </Link>
            </div>
        </div>
    )
}
