'use client'

import { cn } from '@/lib/utils'
import * as Icons from 'lucide-react'

interface StatCardProps {
    label: string
    value: string | number
    change?: string
    iconName: string
    color?: 'blue' | 'green' | 'purple' | 'pink' | 'red'
    loading?: boolean
}

const colorClasses = {
    blue: 'text-blue-400 bg-blue-500/10',
    green: 'text-green-400 bg-green-500/10',
    purple: 'text-purple-400 bg-purple-500/10',
    pink: 'text-pink-400 bg-pink-500/10',
    red: 'text-red-400 bg-red-500/10'
}

export function StatCard({
    label,
    value,
    change,
    iconName,
    color = 'purple',
    loading = false
}: StatCardProps) {
    const Icon = (Icons as any)[iconName]

    if (loading) {
        return (
            <div className="glass p-6 rounded-2xl border-white/5 animate-pulse">
                <div className="h-12 w-12 rounded-xl bg-white/5 mb-4" />
                <div className="h-4 w-24 bg-white/5 rounded mb-2" />
                <div className="h-8 w-32 bg-white/5 rounded" />
            </div>
        )
    }

    return (
        <div className="glass p-6 rounded-2xl border-white/5 hover:border-white/10 transition-all hover:-translate-y-1 duration-300">
            <div className="flex items-start justify-between mb-4">
                <div className={cn("w-12 h-12 rounded-xl flex items-center justify-center", colorClasses[color])}>
                    {Icon && <Icon className="w-6 h-6" />}
                </div>
                {change && (
                    <div className={cn(
                        "flex items-center gap-1 text-sm font-medium px-2 py-1 rounded-lg",
                        change.startsWith('+') ? "text-green-400 bg-green-500/10" : "text-red-400 bg-red-500/10"
                    )}>
                        {change}
                    </div>
                )}
            </div>
            <div>
                <p className="text-gray-400 text-sm font-medium mb-1">{label}</p>
                <h3 className="text-3xl font-bold text-white">{value}</h3>
            </div>
        </div>
    )
}
