'use client'

import { Instagram } from 'lucide-react'
import Image from 'next/image'
import { useTranslations } from 'next-intl'

export function CreatorShowcase() {
    const t = useTranslations('Landing')
    const creators = [
        {
            name: "Eyzuro",
            avatar: "/creators/eyzuro.png",
            followers: "+230k",
            platform: "TikTok",
            socials: {
                tiktok: "https://www.tiktok.com/@eyzuro",
                youtube: "https://www.youtube.com/@eyzuro",
                instagram: "https://www.instagram.com/eyzuro"
            }
        },
        {
            name: "",
            avatar: "", // Empty
            followers: "",
            platform: "",
            socials: { tiktok: "", youtube: "", instagram: "" }
        },
        {
            name: "",
            avatar: "", // Empty
            followers: "",
            platform: "",
            socials: { tiktok: "", youtube: "", instagram: "" }
        },
        {
            name: "",
            avatar: "", // Empty
            followers: "",
            platform: "",
            socials: { tiktok: "", youtube: "", instagram: "" }
        }
    ]

    return (
        <section className="py-24 relative overflow-hidden">
            {/* Background blobs */}
            <div className="absolute top-1/2 left-1/4 w-96 h-96 bg-purple-600/20 rounded-full blur-3xl -translate-y-1/2 -z-10" />
            <div className="absolute bottom-0 right-1/4 w-64 h-64 bg-blue-600/20 rounded-full blur-3xl -z-10" />

            <div className="container mx-auto px-6">
                <div className="flex flex-col md:flex-row items-end justify-between mb-12 gap-6">
                    <div>
                        <h2 className="text-3xl md:text-5xl font-bold mb-4">
                            {t('elite_section.title')} <br />
                            <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-pink-400">{t('elite_section.title_highlight')}</span>
                        </h2>
                        <p className="text-gray-400 max-w-md">
                            {t('elite_section.subtitle')}
                        </p>
                    </div>
                </div>

                <div className="grid grid-cols-2 md:grid-cols-4 gap-6">


                    {creators.map((creator, i) => (
                        <div
                            key={i}
                            className={`group relative aspect-[3/4] rounded-3xl overflow-hidden ${creator.name ? 'cursor-pointer' : 'bg-white/5 border border-white/10'}`}
                        >
                            {creator.name ? (
                                <>
                                    <Image
                                        src={creator.avatar}
                                        alt={creator.name}
                                        fill
                                        className="object-cover transition-transform duration-700 group-hover:scale-110"
                                    />

                                    <div className="absolute inset-0 bg-gradient-to-t from-black/90 via-black/20 to-transparent opacity-80 group-hover:opacity-100 transition-opacity" />

                                    <div className="absolute bottom-0 left-0 right-0 p-3 md:p-6 translate-y-0 md:translate-y-4 md:group-hover:translate-y-0 transition-transform duration-300">
                                        <h3 className="text-sm md:text-xl font-bold text-white mb-1 truncate">{creator.name}</h3>
                                        <div className="flex flex-col md:flex-row md:items-center justify-between gap-2 md:gap-0">
                                            <span className="text-xs md:text-sm text-purple-300 font-medium">{creator.followers}</span>
                                            <div className="flex items-center gap-1.5 md:gap-2">
                                                {/* TikTok */}
                                                <a
                                                    href={creator.socials.tiktok}
                                                    target="_blank"
                                                    rel="noopener noreferrer"
                                                    className="w-6 h-6 md:w-8 md:h-8 rounded-full bg-white/10 backdrop-blur-md flex items-center justify-center hover:bg-black hover:scale-110 transition-all"
                                                    onClick={(e) => e.stopPropagation()}
                                                >
                                                    <svg className="w-3 h-3 md:w-4 md:h-4 text-white" viewBox="0 0 24 24" fill="currentColor">
                                                        <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64 2.93 2.93 0 0 1 .88.13V9.4a6.84 6.84 0 0 0-1-.05A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z" />
                                                    </svg>
                                                </a>

                                                {/* YouTube */}
                                                <a
                                                    href={creator.socials.youtube}
                                                    target="_blank"
                                                    rel="noopener noreferrer"
                                                    className="w-6 h-6 md:w-8 md:h-8 rounded-full bg-white/10 backdrop-blur-md flex items-center justify-center hover:bg-red-600 hover:scale-110 transition-all"
                                                    onClick={(e) => e.stopPropagation()}
                                                >
                                                    <svg className="w-3 h-3 md:w-4 md:h-4 text-white" viewBox="0 0 24 24" fill="currentColor">
                                                        <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z" />
                                                    </svg>
                                                </a>

                                                {/* Instagram */}
                                                <a
                                                    href={creator.socials.instagram}
                                                    target="_blank"
                                                    rel="noopener noreferrer"
                                                    className="w-6 h-6 md:w-8 md:h-8 rounded-full bg-white/10 backdrop-blur-md flex items-center justify-center hover:bg-gradient-to-br hover:from-purple-600 hover:to-pink-600 hover:scale-110 transition-all"
                                                    onClick={(e) => e.stopPropagation()}
                                                >
                                                    <Instagram className="w-3 h-3 md:w-4 md:h-4 text-white" />
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </>
                            ) : (
                                <div className="flex items-center justify-center h-full">
                                    <div className="w-16 h-16 rounded-full bg-white/5 flex items-center justify-center">
                                        <span className="text-3xl font-bold text-white/10">?</span>
                                    </div>
                                </div>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </section>
    )
}
