'use client'

import { useTranslations, useLocale } from 'next-intl'
import { Linkedin } from 'lucide-react'
import { Link } from '@/i18n/routing'
import { cn } from '@/lib/utils'

export function Footer() {
    const t = useTranslations('Landing')
    const locale = useLocale()

    return (
        <footer className="bg-black py-12 relative z-10">
            <div className="container mx-auto px-6">
                {/* Desktop Layout */}
                <div className="hidden md:flex justify-between items-center gap-6">
                    <div className="flex items-center gap-2 opacity-50 hover:opacity-100 transition-opacity text-white">
                        <span className="font-bold">SWIPLAY</span>
                        <span className="text-xs">© 2025</span>
                    </div>

                    <div className="flex gap-8 text-sm text-gray-500 items-center">
                        <div className="flex items-center gap-3 border-r border-white/10 pr-6 mr-2">
                            <Link href="/" locale="fr" className={cn("hover:text-white transition-colors cursor-pointer font-medium", locale === 'fr' && "text-white")}>FR</Link>
                            <span className="text-white/20">|</span>
                            <Link href="/" locale="en" className={cn("hover:text-white transition-colors cursor-pointer font-medium", locale === 'en' && "text-white")}>EN</Link>
                        </div>
                        <Link href="/legal/terms" className="hover:text-white transition-colors cursor-pointer">{t('footer.legal')}</Link>
                        <Link href="/legal/privacy" className="hover:text-white transition-colors cursor-pointer">{t('footer.privacy')}</Link>
                        <a
                            href="https://www.linkedin.com/company/swiplay/"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="hover:text-blue-400 transition-colors cursor-pointer"
                        >
                            <Linkedin className="w-5 h-5" />
                        </a>
                    </div>
                </div>

                {/* Mobile Layout */}
                <div className="md:hidden flex flex-col gap-6">
                    {/* Row 1: Lang - Logo - LinkedIn */}
                    <div className="grid grid-cols-3 items-center">
                        {/* Left: Lang */}
                        <div className="flex items-center gap-2 text-sm text-gray-500 justify-start">
                            <Link href="/" locale="fr" className={cn("hover:text-white transition-colors cursor-pointer font-medium", locale === 'fr' && "text-white")}>FR</Link>
                            <span className="text-white/20">|</span>
                            <Link href="/" locale="en" className={cn("hover:text-white transition-colors cursor-pointer font-medium", locale === 'en' && "text-white")}>EN</Link>
                        </div>

                        {/* Center: Logo */}
                        <div className="flex items-center justify-center gap-1 opacity-50 text-white whitespace-nowrap">
                            <span className="font-bold text-sm">SWIPLAY</span>
                            <span className="text-[10px]">2025</span>
                        </div>

                        {/* Right: LinkedIn */}
                        <div className="flex justify-end">
                            <a
                                href="https://www.linkedin.com/company/swiplay/"
                                target="_blank"
                                rel="noopener noreferrer"
                                className="text-gray-500 hover:text-blue-400 transition-colors cursor-pointer"
                            >
                                <Linkedin className="w-5 h-5" />
                            </a>
                        </div>
                    </div>

                    {/* Row 2: Legal Links */}
                    <div className="flex items-center justify-center gap-4 text-xs text-gray-500">
                        <Link href="/legal/terms" className="hover:text-white transition-colors cursor-pointer whitespace-nowrap">{t('footer.legal')}</Link>
                        <Link href="/legal/privacy" className="hover:text-white transition-colors cursor-pointer whitespace-nowrap">{t('footer.privacy')}</Link>
                    </div>
                </div>
            </div>
        </footer>
    )
}
