import { useTranslations } from 'next-intl'
import { cn } from '@/lib/utils'
import { UserPlus, FileVideo, Banknote, Search, CheckSquare, TrendingUp, ArrowRight } from 'lucide-react'

interface HowItWorksProps {
    activeView: 'studio' | 'creator'
}

export function HowItWorks({ activeView }: HowItWorksProps) {
    const t = useTranslations('Landing.how_it_works')

    const studioSteps = [
        {
            icon: Search,
            title: t('studio_step1_title'),
            desc: t('studio_step1_desc')
        },
        {
            icon: UserPlus,
            title: t('studio_step2_title'),
            desc: t('studio_step2_desc')
        },
        {
            icon: TrendingUp,
            title: t('studio_step3_title'),
            desc: t('studio_step3_desc')
        }
    ]

    const creatorSteps = [
        {
            icon: UserPlus,
            title: t('creator_step1_title'),
            desc: t('creator_step1_desc')
        },
        {
            icon: FileVideo,
            title: t('creator_step2_title'),
            desc: t('creator_step2_desc')
        },
        {
            icon: Banknote,
            title: t('creator_step3_title'),
            desc: t('creator_step3_desc')
        }
    ]

    const steps = activeView === 'studio' ? studioSteps : creatorSteps

    return (
        <section id="how-it-works" className="py-24 px-6 relative z-10 bg-black/20 backdrop-blur-sm">
            <div className="container mx-auto max-w-6xl">
                <div className="text-center mb-16">
                    <h2 className="text-3xl md:text-5xl font-bold mb-6">
                        {t('title')} <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-blue-500">{t('title_highlight')}</span> ?
                    </h2>
                    <p className="text-gray-400 max-w-2xl mx-auto text-lg">
                        {activeView === 'studio' ? t('subtitle_studio') : t('subtitle_creator')}
                    </p>
                </div>

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8 relative">
                    {/* Connecting Line (Desktop) */}
                    <div className="hidden md:block absolute top-12 left-[16%] right-[16%] h-0.5 bg-gradient-to-r from-transparent via-white/10 to-transparent" />

                    {steps.map((step, i) => (
                        <div key={i} className="relative flex flex-col items-center text-center group">
                            <div className={cn(
                                "w-24 h-24 rounded-3xl flex items-center justify-center mb-8 relative z-10 transition-all duration-500 group-hover:scale-110 group-hover:rotate-3",
                                activeView === 'studio'
                                    ? "bg-blue-500/10 border border-blue-500/20 group-hover:border-blue-500/50"
                                    : "bg-purple-500/10 border border-purple-500/20 group-hover:border-purple-500/50"
                            )}>
                                <step.icon className={cn(
                                    "w-10 h-10 transition-colors duration-500",
                                    activeView === 'studio' ? "text-blue-400" : "text-purple-400"
                                )} />
                            </div>

                            <h3 className="text-xl font-bold mb-3 text-white">
                                {step.title}
                            </h3>

                            <p className="text-gray-400 leading-relaxed max-w-xs">
                                {step.desc}
                            </p>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    )
}
