'use client'

import Image from 'next/image'
import { useTranslations } from 'next-intl'

export function TrustSection() {
    const t = useTranslations('Landing')
    const logos = [
        "ankama_blanc.png",
        "gameforge_blanc.png",
        "magic_blanc.png",
        "twofrogs_blanc.png"
    ]

    return (
        <section id="trust-section" className="py-12 bg-black/20 backdrop-blur-sm">
            <div className="container mx-auto px-6">
                <p className="text-center text-lg text-gray-500 uppercase tracking-widest mb-10 font-medium">
                    {t('trust_title')}
                </p>

                {/* Static grid for desktop, no scrolling */}
                <div className="hidden md:flex items-center justify-center gap-20">
                    {logos.map((logo, i) => (
                        <div key={i} className="relative w-48 h-24 opacity-50 hover:opacity-100 transition-opacity duration-300 grayscale hover:grayscale-0">
                            <Image
                                src={`/images/${logo}`}
                                alt="Partner logo"
                                fill
                                className="object-contain"
                            />
                        </div>
                    ))}
                </div>

                {/* Scrolling version for mobile only */}
                <div className="relative flex overflow-hidden md:hidden [mask-image:linear-gradient(to_right,transparent,black_20%,black_80%,transparent)]">
                    <div className="flex animate-scroll-infinite whitespace-nowrap py-4">
                        {[...Array(3)].map((_, setIndex) => (
                            <div key={setIndex} className="flex items-center gap-16 mx-8">
                                {logos.map((logo, i) => (
                                    <div key={`${setIndex}-${i}`} className="relative w-32 h-16 opacity-50 grayscale">
                                        <Image
                                            src={`/images/${logo}`}
                                            alt="Partner logo"
                                            fill
                                            className="object-contain"
                                        />
                                    </div>
                                ))}
                            </div>
                        ))}
                    </div>
                </div>
            </div>

            <style jsx>{`
        .animate-scroll-infinite {
          animation: scroll 30s linear infinite;
        }
        @keyframes scroll {
          0% { transform: translateX(0); }
          100% { transform: translateX(-33.33%); }
        }
      `}</style>
        </section>
    )
}
