import jwt from 'jsonwebtoken'

const JWT_SECRET = process.env.JWT_SECRET || 'swiplay-v3-development-secret-change-in-production'

export async function verifyToken(token: string): Promise<any> {
  try {
    const decoded = jwt.verify(token, JWT_SECRET)
    return decoded
  } catch (error) {
    return null
  }
}

export function generateToken(payload: any): string {
  return jwt.sign(payload, JWT_SECRET, { expiresIn: '30d' })
}
