import { drizzle } from 'drizzle-orm/node-postgres'
import { Pool } from 'pg'
import * as schema from './schema'

// Allow runtime to work without DATABASE_URL (for Next.js frontend)
const connectionString = process.env.DATABASE_URL || process.env.NEXT_PUBLIC_DATABASE_URL

if (!connectionString && typeof window === 'undefined') {
  // Only throw in Node.js environment (server/backend)
  console.warn('Warning: DATABASE_URL not set, database will not be available')
}

const pool = connectionString ? new Pool({
  connectionString,
}) : null as any

export const db = pool ? drizzle(pool, { schema }) : null as any
