import { db } from '@/lib/db'

import { notificationQueue } from '@/lib/db/schema'

export async function sendDiscordNotification(
    title: string,
    message: string,
    type: 'info' | 'success' | 'warning' | 'error' = 'info',
    fields?: { name: string; value: string; inline?: boolean }[]
) {
    const payload = {
        title,
        message,
        type,
        fields
    }

    try {
        await db.insert(notificationQueue).values({
            type: 'discord',
            payload: JSON.stringify(payload),
            status: 'pending',
        })
    } catch (error) {
        console.error('Failed to queue Discord notification:', error)
    }
}
