import { z } from "zod"

export const loginSchema = z.object({
    email: z.string().email("Email invalide"),
    role: z.enum(["creator", "studio", "admin"]),
    code: z.string().length(6, "Le code doit contenir 6 chiffres").optional(),
})

export const registerSchema = z.object({
    name: z.string().min(2, "Le nom doit contenir au moins 2 caractères"),
    email: z.string().email("Email invalide"),
    role: z.enum(["creator", "studio"]),
    company: z.string().optional(),
})

export const verifySchema = z.object({
    email: z.string().email("Email invalide"),
    code: z.string().length(6, "Le code doit contenir 6 chiffres"),
})
