import { z } from "zod"

export const campaignSchema = z.object({
    title: z.string().min(5, "Le titre doit contenir au moins 5 caractères").max(100),
    description: z.string().min(20, "La description doit contenir au moins 20 caractères"),
    budget: z.coerce.number().min(100, "Le budget minimum est de 100€"),
    pricePerView: z.coerce.number().min(0.01, "Le prix par vue minimum est de 0.01€"),
    creatorCap: z.coerce.number().min(10, "Le plafond par créateur doit être d'au moins 10€").optional(),
    startDate: z.string().optional(),
    endDate: z.string().optional(),
    platform: z.enum(["tiktok", "youtube", "instagram"]),

    // Visuals
    coverImage: z.string().optional(),
    icon: z.string().optional(),
    images: z.array(z.string()).optional(),
    tags: z.array(z.string()).optional(),

    // Game Keys
    gameKeys: z.array(z.object({
        platform: z.string(),
        keys: z.string() // Newline separated keys
    })).optional(),

    // Assets
    assets: z.array(z.object({
        name: z.string(),
        type: z.enum(['file', 'link']),
        url: z.string(),
        size: z.number().optional()
    })).optional(),
})
