/*!
 * CSS color - Resolve, parse, convert CSS color.
 * @license MIT
 * @copyright asamuzaK (Kazz)
 * @see {@link https://github.com/asamuzaK/cssColor/blob/main/LICENSE}
 */

import { cssCalc } from './js/css-calc';
import { isGradient, resolveGradient } from './js/css-gradient';
import { cssVar } from './js/css-var';
import {
  extractDashedIdent,
  isColor,
  resolveLengthInPixels,
  splitValue
} from './js/util';

export { convert } from './js/convert';
export { resolve } from './js/resolve';
/* utils */
export const utils = {
  cssCalc,
  cssVar,
  extractDashedIdent,
  isColor,
  isGradient,
  resolveGradient,
  resolveLengthInPixels,
  splitValue
};
