/*!
 * This source file is part of the Gel open source project.
 *
 * Copyright 2019-present MagicStack Inc. and the Gel authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import type { ICodec, uuid, CodecKind } from "./ifaces";
import { Codec } from "./ifaces";
import { ReadBuffer, WriteBuffer } from "../primitives/buffer";
import type { CodecContext } from "./context";
export declare class TupleCodec extends Codec implements ICodec {
    private subCodecs;
    typeName: string | null;
    constructor(tid: uuid, typeName: string | null, codecs: ICodec[]);
    encode(buf: WriteBuffer, object: any, ctx: CodecContext): void;
    decode(buf: ReadBuffer, ctx: CodecContext): any;
    getSubcodecs(): ICodec[];
    getKind(): CodecKind;
}
export declare class EmptyTupleCodec extends Codec implements ICodec {
    static BUFFER: Uint8Array;
    encode(buf: WriteBuffer, object: any, _ctx: CodecContext): void;
    decode(buf: ReadBuffer): any;
    getSubcodecs(): ICodec[];
    getKind(): CodecKind;
}
export declare const EMPTY_TUPLE_CODEC_ID: string;
export declare const EMPTY_TUPLE_CODEC: EmptyTupleCodec;
