"use strict";
/*!
 * This source file is part of the Gel open source project.
 *
 * Copyright 2019-present MagicStack Inc. and the Gel authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.$v = exports.$s = exports.$r = exports.$p = exports.$o = exports.$n = exports.$m = exports.$j = exports.$b = exports.$Z = exports.$Y = exports.$X = exports.$V = exports.$T = exports.$S = exports.$R = exports.$Q = exports.$P = exports.$O = exports.$M = exports.$L = exports.$K = exports.$I = exports.$H = exports.$E = exports.$D = exports.$C = exports.$A = exports.$1 = exports.$0 = void 0;
exports.ord = ord;
exports.chr = chr;
exports.$0 = ord("0");
exports.$1 = ord("1");
exports.$A = ord("A");
exports.$C = ord("C");
exports.$D = ord("D");
exports.$E = ord("E");
exports.$H = ord("H");
exports.$I = ord("I");
exports.$K = ord("K");
exports.$L = ord("L");
exports.$M = ord("M");
exports.$O = ord("O");
exports.$P = ord("P");
exports.$Q = ord("Q");
exports.$R = ord("R");
exports.$S = ord("S");
exports.$T = ord("T");
exports.$V = ord("V");
exports.$X = ord("X");
exports.$Y = ord("Y");
exports.$Z = ord("Z");
exports.$b = ord("b");
exports.$j = ord("j");
exports.$m = ord("m");
exports.$n = ord("n");
exports.$o = ord("o");
exports.$p = ord("p");
exports.$r = ord("r");
exports.$s = ord("s");
exports.$v = ord("v");
function ord(str) {
    const ch = str.charCodeAt(0);
    if (ch <= 0 || ch >= 255) {
        throw new TypeError(`char "${ch}" is outside ASCII`);
    }
    return ch & 0xff;
}
function chr(ch) {
    if (ch <= 0 || ch >= 255) {
        throw new TypeError(`char "${ch}" is outside ASCII`);
    }
    return String.fromCharCode(ch);
}
