import CatalogManager from './catalog/CatalogManager.js';

class ExtractionCompiler {
  isDevelopment = false;
  constructor(config, opts = {}) {
    this.manager = new CatalogManager(config, opts);
    this.isDevelopment = opts.isDevelopment ?? false;

    // Kick off the initial scan as early as possible,
    // while awaiting it in `compile`. This also ensures
    // we're only scanning once.
    this.initialScanPromise = this.performInitialScan();
  }
  async compile(resourcePath, source) {
    if (this.initialScanPromise) {
      await this.initialScanPromise;
      this.initialScanPromise = undefined;
    }
    const result = await this.manager.extractFileMessages(resourcePath, source);
    if (this.isDevelopment && result.changed) {
      // While we await the AST modification, we
      // don't need to await the persistence
      void this.manager.save();
    }
    return result;
  }
  async performInitialScan() {
    // We can't rely on all files being compiled (e.g. due to persistent
    // caching), so loading the messages initially is necessary.
    await this.manager.loadMessages();
    await this.manager.save();
  }
  async extract() {
    await this.initialScanPromise;
  }
  [Symbol.dispose]() {
    this.manager.destroy();
  }
}

export { ExtractionCompiler as default };
