import path from 'path';
import formatters from './formatters/index.js';

let cachedFormatter = null;
async function getFormatter(options) {
  if (!cachedFormatter) {
    const FormatterClass = (await formatters[options.messages.format]()).default;
    cachedFormatter = new FormatterClass();
  }
  return cachedFormatter;
}

/**
 * Parses and optimizes catalog files.
 *
 * Note that if we use a dynamic import like `import(`${locale}.json`)`, then
 * the loader will optimistically run for all candidates in this folder (both
 * during dev as well as at build time).
 */
function catalogLoader(source) {
  const options = this.getOptions();
  const callback = this.async();
  getFormatter(options).then(formatter => {
    const locale = path.basename(this.resourcePath, formatter.EXTENSION);
    const jsonString = formatter.toJSONString(source, {
      locale
    });

    // https://v8.dev/blog/cost-of-javascript-2019#json
    const result = `export default JSON.parse(${JSON.stringify(jsonString)});`;
    callback(null, result);
  }).catch(callback);
}

export { catalogLoader as default };
