import { setNestedProperty } from '../utils/ObjectUtils.js';
import Formatter from './Formatter.js';
import { getSortedMessages } from './utils.js';

class JSONFormatter extends Formatter {
  static NAMESPACE_SEPARATOR = '.';
  EXTENSION = '.json';
  parse(source) {
    const json = JSON.parse(source);
    const messages = [];
    this.traverseMessages(json, (message, id) => {
      messages.push({
        id,
        message
      });
    });
    return messages;
  }
  serialize(messages) {
    const root = {};
    for (const message of getSortedMessages(messages)) {
      setNestedProperty(root, message.id, message.message);
    }
    return JSON.stringify(root, null, 2);
  }
  toJSONString(source) {
    return source;
  }
  traverseMessages(obj, callback, path = '') {
    for (const key of Object.keys(obj)) {
      const newPath = path ? path + JSONFormatter.NAMESPACE_SEPARATOR + key : key;
      const value = obj[key];
      if (typeof value === 'string') {
        callback(value, newPath);
      } else if (typeof value === 'object') {
        this.traverseMessages(value, callback, newPath);
      }
    }
  }
}

export { JSONFormatter as default };
