function getSortedMessages(messages) {
  return messages.toSorted((messageA, messageB) => {
    const pathA = messageA.references?.[0]?.path ?? '';
    const pathB = messageB.references?.[0]?.path ?? '';
    if (pathA === pathB) {
      return messageA.id.localeCompare(messageB.id);
    } else {
      return pathA.localeCompare(pathB);
    }
  });
}

export { getSortedMessages };
