import type { ExtractorConfig } from './types.js';
export default class ExtractionCompiler implements Disposable {
    private manager;
    private isDevelopment;
    private initialScanPromise;
    constructor(config: ExtractorConfig, opts?: {
        isDevelopment?: boolean;
        projectRoot?: string;
        sourceMap?: boolean;
    });
    compile(resourcePath: string, source: string): Promise<{
        messages: Array<import("./types.js").ExtractedMessage>;
        code: string;
        changed: boolean;
        map?: string;
    }>;
    private performInitialScan;
    extract(): Promise<void>;
    [Symbol.dispose](): void;
}
