import type { ExtractedMessage, ExtractorConfig } from '../types.js';
export default class CatalogManager {
    private config;
    private messagesByFile;
    private messagesById;
    /**
     * This potentially also includes outdated ones that were initially available,
     * but are not used anymore. This allows to restore them if they are used again.
     **/
    private translationsByTargetLocale;
    private lastWriteByLocale;
    private saveScheduler;
    private projectRoot;
    private isDevelopment;
    private persister?;
    private formatter?;
    private catalogLocales?;
    private messageExtractor;
    constructor(config: ExtractorConfig, opts?: {
        projectRoot?: string;
        isDevelopment?: boolean;
        sourceMap?: boolean;
    });
    private getFormatter;
    private getPersister;
    private getCatalogLocales;
    private getTargetLocales;
    getSrcPaths(): Array<string>;
    getFileMessages(absoluteFilePath: string): Map<string, ExtractedMessage> | undefined;
    loadMessages(): Promise<void>;
    private loadSourceMessages;
    private loadLocaleMessages;
    private loadTargetMessages;
    extractFileMessages(absoluteFilePath: string, source: string): Promise<{
        messages: Array<ExtractedMessage>;
        code: string;
        changed: boolean;
        map?: string;
    }>;
    private haveMessagesChanged;
    private areMessagesEqual;
    private areReferencesEqual;
    save(): Promise<number>;
    private saveImpl;
    private saveLocale;
    private onLocalesChange;
    destroy(): void;
}
