type SaveTask<T> = () => Promise<T>;
/**
 * De-duplicates excessive save invocations,
 * while keeping a single one instant.
 */
export default class SaveScheduler<Value> {
    private saveTimeout?;
    private isSaving;
    private delayMs;
    private pendingResolvers;
    constructor(delayMs?: number);
    schedule(saveTask: SaveTask<Value>): Promise<Value>;
    private scheduleSave;
    private executeSave;
    destroy(): void;
}
export {};
