import type { ExtractedMessage } from '../types.js';
type StrictExtractedMessage = ExtractedMessage & {
    references: NonNullable<ExtractedMessage['references']>;
};
export default class MessageExtractor {
    private isDevelopment;
    private projectRoot;
    private sourceMap;
    private compileCache;
    constructor(opts: {
        isDevelopment: boolean;
        projectRoot: string;
        sourceMap?: boolean;
    });
    processFileContent(absoluteFilePath: string, source: string): Promise<{
        messages: Array<StrictExtractedMessage>;
        code: string;
        map?: string;
    }>;
}
export {};
