export type MessagesFormat = 'json' | 'po';
export type Locale = string;
export type ExtractedMessage = {
    id: string;
    message: string;
    description?: string;
    references?: Array<{
        path: string;
    }>;
};
export type MessagesConfig = {
    path: string;
    format: MessagesFormat;
    locales: 'infer' | ReadonlyArray<Locale>;
};
export type ExtractorConfig = {
    srcPath: string | Array<string>;
    sourceLocale: string;
    messages: MessagesConfig;
};
export type CatalogLoaderConfig = {
    messages: MessagesConfig;
};
