const S3rver = require('s3rver');
const path = require('path');
const fs = require('fs');

const bucketName = 'swiplay-assets';
const directory = path.join(__dirname, '../.s3');

// Ensure directory exists
if (!fs.existsSync(directory)) {
    fs.mkdirSync(directory, { recursive: true });
}

new S3rver({
    port: 4568,
    address: 'localhost',
    directory: directory,
    configureBuckets: [
        {
            name: bucketName,
            configs: [fs.readFileSync(path.join(__dirname, 's3-cors.xml'))],
        },
    ],
}).run((err, { address, port } = {}) => {
    if (err) {
        console.error(err);
    } else {
        console.log(`S3rver running at http://${address}:${port}`);
    }
});
