
import { Pool } from 'pg'

async function test(url: string) {
    console.log(`Testing URL: ${url}`)
    const pool = new Pool({ connectionString: url })
    try {
        const client = await pool.connect()
        console.log('Connected successfully')
        client.release()
    } catch (e) {
        console.error('Connection failed:', e)
    }
    await pool.end()
}

const urlWithQuotes = '"postgresql://postgres:q6%3B4GZzP1Eb.l8@localhost:5432/swiplay_v3"'
const urlWithoutQuotes = 'postgresql://postgres:q6%3B4GZzP1Eb.l8@localhost:5432/swiplay_v3'

async function main() {
    console.log('--- Testing WITH quotes ---')
    await test(urlWithQuotes)

    console.log('\n--- Testing WITHOUT quotes ---')
    await test(urlWithoutQuotes)
}

main()
