
import axios from 'axios';
import * as cheerio from 'cheerio';

async function test() {
    console.log('Testing Dumpoir Scraper for eyzuro...');
    try {
        const url = `https://dumpoir.com/v/eyzuro`;
        const response = await axios.get(url, {
            headers: {
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8',
            },
            timeout: 15000
        });

        console.log('Status:', response.status);
        if (response.status === 200) {
            const html = response.data;
            console.log('HTML Length:', html.length);

            // Regex search
            const match = html.match(/([0-9,.]+[KMB]?)\s*Followers/i) || html.match(/Followers\s*([0-9,.]+[KMB]?)/i);
            if (match) {
                console.log('Regex Match:', match[1]);
            } else {
                console.log('No regex match found.');
                // console.log('HTML Sample:', html.substring(0, 1000)); 
            }
        }
    } catch (error) {
        console.error('Error:', error.message);
    }
}

test();
