
import puppeteer from 'puppeteer';

const PROFILE_REELS_URL = 'https://www.instagram.com/eyzuro/reels/';
const REEL_ID = 'DQXLRfljOGH';

async function run() {
    console.log(`--- Testing Puppeteer on Profile Reels: ${PROFILE_REELS_URL} ---`);
    const browser = await puppeteer.launch({
        headless: true,
        args: ['--no-sandbox', '--disable-setuid-sandbox', '--disable-dev-shm-usage', '--disable-accelerated-2d-canvas', '--disable-gpu']
    });

    let page;
    try {
        page = await browser.newPage();
        await page.setUserAgent('Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36');

        console.log('Navigating to profile reels...');
        await page.goto(PROFILE_REELS_URL, { waitUntil: 'networkidle2' });

        const reelLinkSelector = `a[href*="${REEL_ID}"]`;
        await page.waitForSelector(reelLinkSelector, { timeout: 15000 });

        const reelLink = await page.$(reelLinkSelector);
        if (reelLink) {
            console.log('✅ Found Reel Link!');
            const parentText = await page.evaluate(el => el.parentElement?.innerText, reelLink);
            console.log(`Parent Inner Text: "${parentText}"`);

            const countMatch = parentText?.match(/([0-9,.]+[KMB]?)/);
            if (countMatch) {
                console.log(`✅ Potential View Count: ${countMatch[0]}`);
            }
        } else {
            console.log('❌ Reel Link NOT found.');
        }

    } catch (error: any) {
        console.error(`Error: ${error.message}`);
        await page.screenshot({ path: 'debug_error.png' });
        console.log('Saved debug_error.png');
    } finally {
        await browser.close();
    }
}

run();
