
import { SocialScraper } from '../lib/social-scraper'

async function test() {
    console.log('Testing Social Scraper...')

    const urls = [
        { platform: 'tiktok', url: 'https://www.tiktok.com/@eyzuro/video/7564017772892605718' },
        { platform: 'youtube', url: 'https://www.youtube.com/shorts/zp0NA-c45wk' },
        { platform: 'instagram', url: 'https://www.instagram.com/p/DO8yd1_jAwv/' }
    ]

    const scraper = new SocialScraper()

    for (const { platform, url } of urls) {
        console.log(`\nTesting ${platform}...`)
        try {
            const stats = await scraper.getStats(platform, url)
            if (stats) {
                console.log(`✅ Success for ${platform}:`)
                console.log(JSON.stringify(stats, null, 2))
            } else {
                console.log(`❌ Failed to scrape ${platform} (returned null)`)
            }
        } catch (error) {
            console.error(`❌ Error scraping ${platform}:`, error)
        }
    }
}

test()
