
import { getInstagramFollowers, getTikTokFollowers, getYouTubeSubscribers } from '../lib/social-scraper';

async function test() {
    console.log('=== Testing Social Avatars ===\n');

    // Instagram (Already verified, but good to double check)
    console.log('Testing Instagram (mohahnz)...');
    try {
        const insta = await getInstagramFollowers('mohahnz');
        console.log('Instagram Avatar:', insta?.avatarUrl ? '✅ Found' : '❌ Missing', insta?.avatarUrl);
    } catch (e) { console.error(e); }

    // YouTube
    console.log('\nTesting YouTube (MrBeast)...');
    try {
        // Using a known channel ID or handle
        const youtube = await getYouTubeSubscribers('@MrBeast');
        console.log('YouTube Avatar:', youtube?.avatarUrl ? '✅ Found' : '❌ Missing', youtube?.avatarUrl);
    } catch (e) { console.error(e); }

    // TikTok
    console.log('\nTesting TikTok (khaby.lame)...');
    try {
        const tiktok = await getTikTokFollowers('khaby.lame');
        console.log('TikTok Avatar:', tiktok?.avatarUrl ? '✅ Found' : '❌ Missing', tiktok?.avatarUrl);
    } catch (e) { console.error(e); }
}

test();
