import { db } from '../lib/db'
import { rateLimits, notificationQueue } from '../lib/db/schema'
import { DbRateLimiter } from '../lib/rate-limit-db'
import { eq } from 'drizzle-orm'

async function verify() {
  console.log('🔍 Starting Verification...')

  // 1. Test Rate Limiter
  console.log('\nTesting Rate Limiter...')
  const limiter = new DbRateLimiter(60 * 1000) // 1 minute
  const key = 'test-verification-key'

  // Clear previous test
  await db.delete(rateLimits).where(eq(rateLimits.key, key))

  const allowed1 = await limiter.check(2, key)
  console.log(`Attempt 1 (Should be true): ${allowed1}`)

  const allowed2 = await limiter.check(2, key)
  console.log(`Attempt 2 (Should be true): ${allowed2}`)

  const allowed3 = await limiter.check(2, key)
  console.log(`Attempt 3 (Should be false): ${allowed3}`)

  if (allowed1 && allowed2 && !allowed3) {
    console.log('✅ Rate Limiter Logic: PASS')
  } else {
    console.error('❌ Rate Limiter Logic: FAIL')
  }

  // 2. Test Notification Queue
  console.log('\nTesting Notification Queue...')
  const payload = JSON.stringify({ title: 'Test', message: 'Verification' })
  
  const [inserted] = await db.insert(notificationQueue).values({
    type: 'test',
    payload,
    status: 'pending'
  }).returning()

  if (inserted && inserted.status === 'pending') {
    console.log('✅ Notification Queue Insert: PASS')
    // Cleanup
    await db.delete(notificationQueue).where(eq(notificationQueue.id, inserted.id))
  } else {
    console.error('❌ Notification Queue Insert: FAIL')
  }

  console.log('\nVerification Complete.')
  process.exit(0)
}

verify().catch(err => {
  console.error(err)
  process.exit(1)
})
