import { describe, it, expect, vi } from 'vitest'
import { validateSocialLink } from '@/lib/social-validation'

describe('Social Link Validation', () => {
    it('should validate TikTok URLs', () => {
        expect(validateSocialLink('https://www.tiktok.com/@user/video/1234567890', 'tiktok')).toBe(true)
        expect(validateSocialLink('https://tiktok.com/invalid', 'tiktok')).toBe(false)
    })

    it('should validate Instagram URLs', () => {
        expect(validateSocialLink('https://www.instagram.com/p/12345abcde', 'instagram')).toBe(true)
        expect(validateSocialLink('https://www.instagram.com/reel/12345abcde', 'instagram')).toBe(true)
        expect(validateSocialLink('https://instagram.com/invalid', 'instagram')).toBe(false)
    })

    it('should validate YouTube URLs', () => {
        expect(validateSocialLink('https://www.youtube.com/watch?v=abcdefghijk', 'youtube')).toBe(true)
        expect(validateSocialLink('https://youtu.be/abcdefghijk', 'youtube')).toBe(true)
        expect(validateSocialLink('https://www.youtube.com/shorts/abcdefghijk', 'youtube')).toBe(true)
        expect(validateSocialLink('https://youtube.com/invalid', 'youtube')).toBe(false)
    })
})
