import { describe, it, expect } from 'vitest'
import { cn, formatCurrency, formatDate, formatNumber } from '@/lib/utils'

describe('Utils', () => {
    describe('cn', () => {
        it('should merge class names', () => {
            expect(cn('c1', 'c2')).toBe('c1 c2')
        })

        it('should handle conditional classes', () => {
            expect(cn('c1', true && 'c2', false && 'c3')).toBe('c1 c2')
        })

        it('should merge tailwind classes', () => {
            expect(cn('p-4', 'p-2')).toBe('p-2')
        })
    })

    describe('formatCurrency', () => {
        it('should format number to EUR', () => {
            // Note: exact output depends on locale, but we expect it to contain '€'
            expect(formatCurrency(1000)).toContain('€')
            expect(formatCurrency(1000)).toContain('1')
        })

        it('should handle string input', () => {
            expect(formatCurrency('1000')).toContain('€')
        })
    })

    describe('formatDate', () => {
        it('should format date correctly', () => {
            const date = new Date('2023-01-01')
            expect(formatDate(date)).toBe('1 janv. 2023')
        })
    })

    describe('formatNumber', () => {
        it('should format number with locale', () => {
            expect(formatNumber(1000)).toContain('1')
        })
    })
})
